* set wd
cd " "
clear
use "04037-0001-Data.dta"

*Interview id
rename V5 id

*How much of the time trust the government in Washington to do what is right? About always - most of the time - (only) some of the time
recode V93 (1=3) (3=2) (5=1),gen(trust65)
recode V1120 (1=3) (3=2) (5=1),gen(trust82)
recode V5120 (1=3) (3=2) (5=1),gen(trust97)

*These are the same in all years but since they have separate variables...
rename V231 sex65
rename V752 sex82
rename V2325 sex97

gen born=V222+1900
gen age65=1965-born
gen age82=1982-born
gen age97=1997-born

*Only asked about parents' education in 65 (when most respondents were 19), then asked about education in 73 and then about change in education level in 82 and 97
rename V767 edu73
gen edu82=edu73
replace edu82=3 if V2021==1
replace edu82=2 if V2021>1 & V2021<8
gen edu97=edu82
replace edu97=3 if V6224==1
replace edu97=2 if V6223==1 & V6224==5

*Income is for family income, categories are not consistent between years but here we recode it to relative income status within each year anyway
recode V744 (0=.),gen(income73_)
xtile income73=income73_,n(5)
recode V2318 (0 97=.),gen(income82_)
xtile income82=income82_,n(5)
recode V6401 (0=.),gen(income97_)
xtile income97=income97_,n(5)

*Working status - not asked in 65
recode V684 (1=1) (nonmis=0),gen(workstatus73)
recode V2038 (1=1) (nonmis=0),gen(workstatus82)
recode V6232 (10 13 15=1) (nonmis=0),gen(workstatus97)

save "US_Panel_6597_4waves.dta",replace

*Reshape to long
reshape long trust sex age edu income workstatus, i(id) j(year)

replace year=1900+year
keep year id trust trust_ch sex age edu income workstatus

save "US_Panel_6597_long.dta",replace